from files_folders.AbstractFile import AbstractFile, _deleted_check


class AbstractExtension(AbstractFile):
    ''' Abstract class representing a File with a specific extension.
    Doesn't allow to change the file extension.

    Added arg and attribute:
        mainExtension: extensions of the file (no point at the beginning)

    Raise:
        AttributeError: if provided file isn't the right extension.
    '''
    # See AbstractFile docstring for more information

    def __init__(self, path, mainExtension, secondaryExt = "", createIfNotFound=False, createFolderIfNotFound=False):

        if not path.endswith('.' + mainExtension):
            raise AttributeError(f"Can't instanciate an class <{self.__class__}> if the file path doesn't end with <{mainExtension}>")

        super().__init__(path, secondaryExt=secondaryExt, createIfNotFound=createIfNotFound, createFolderIfNotFound=createFolderIfNotFound)
        self.theoricMainExtension = mainExtension

    @_deleted_check
    def rename(self, fileName, secondaryExt = "", replaceIfExist=False):
        '''If you try to replace the main extension, raise AttributeError.'''
        # Rename docstring of parent class

        if fileName.find('.') != -1 and not fileName.endswith('.' + self.theoricMainExtension):
            raise AttributeError(f"You can't modify the main extension of this file. The object you are handling is linked to this extension: <{self.__class__}>")

        return super().rename(fileName, secondaryExt=secondaryExt, replaceIfExist=replaceIfExist)
