class FolderNotFoundError(OSError):
    """ OSError raised for folders not found.

    Args:
        folderPath (string)
        message (string="")
    """

    def __init__(self, folderPath, message=""):
        self.message = message
        self.folderPath = folderPath
        super().__init__(self.message)

    def __str__(self):
        if self.message == "":
            return f"No folder found at: {self.folderPath}"
        return f"No folder found at: {self.folderPath}\n{self.message}"


class FolderExistsError(OSError):
    """ OSError raised for folder found.

    Args:
        folderPath (string)
        message (string="")
    """

    def __init__(self, folderPath, message=""):
        self.message = message
        self.folderPath = folderPath
        super().__init__(self.message)

    def __str__(self):
        if self.message == "":
            return f"Folder exist at: {self.folderPath}"
        return f"Folder exist at: {self.folderPath}\n{self.message}"

class FileNotFoundError(OSError):
    """ OSError raised for file not found.

    Args:
        filePath (string): full path
        message (string="")
    """

    def __init__(self, filePath, message=""):
        self.message = message
        self.filePath = filePath
        super().__init__(self.message)

    def __str__(self):
        if self.message == "":
            return f"No file found at: {self.filePath}"
        return f"No file found at: {self.filePath}\n{self.message}"


class FileExistsError(OSError):
    """ OSError raised for file found.

    Args:
        filePath (string): full path
        message (string="")
    """

    def __init__(self, filePath, message=""):
        self.message = message
        self.filePath = filePath
        super().__init__(self.message)

    def __str__(self):
        if self.message == "":
            return f"File exist at: {self.filePath}"
        return f"File exist at: {self.filePath}\n{self.message}"